#include<uart.h>
#include<p30fxxxx.h>

/*********************************************************************
* Function Name     : ConfigIntUART1
* Description       : This function sets priority for RX,TX interrupt  
*                     and enable/disables the interrupt
* Parameters        : unsigned int config enable/disable and priority
* Return Value      : None
*********************************************************************/

void ConfigIntUART1(unsigned int config)
{
    /* clear IF flags */
    IFS0bits.U1RXIF = 0;
    IFS0bits.U1TXIF = 0;

    /* set priority */
    IPC2bits.U1RXIP = 0x0007 & config;
    IPC2bits.U1TXIP = (0x0070 & config) >> 4;

    /* enable/disable interrupt */
    IEC0bits.U1RXIE = (0x0008 & config) >> 3;
    IEC0bits.U1TXIE = (0x0080 & config) >> 7;
}
